-- Library and Use statements for IEEE packages
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity top is
port(
Clk   : in  std_logic;
En1	  : in  std_logic;
out2 : out std_logic_vector (7 downto 0)
);

end top;

architecture behave of top is

signal CNT1: std_logic_vector (1 downto 0):="00";
signal CNT2: std_logic_vector (7 downto 0):="00000000";
signal CNT2_d: std_logic_vector (7 downto 0):="00000000";

signal clk2, Enable : std_logic;

COMPONENT DCC 
 generic (DCCEN : String);
PORT (
		CLKI :IN STD_LOGIC; 
		CE :IN STD_LOGIC; 
		CLKO :OUT STD_LOGIC
		); 
END COMPONENT;
  
begin

process(clk)
begin
if rising_edge(clk) then
	if En1='1' then 
		CNT1 <= CNT1+1 ;
	else 
		CNT1 <= CNT1 ;
	end if;
end if;
end process;

Enable <= '1' when CNT1 ="11" else '0';

MyDCC : DCC   
generic map (DCCEN  => "1")
port map (
  CE   => Enable,  -- I
  CLKI => CLK,  -- I
  CLKO => CLK2   -- O
);

process(clk2)
begin
if rising_edge(clk2) then
	CNT2 <= CNT2 + 1;
end if;
end process;

process(clk2)
begin
if falling_edge(clk2) then
	CNT2_d <= CNT2 ;
end if;
end process;

out2 <= CNT2_d;

end behave;